function [comp_LL, Rt, veclRt] = CompositeLLNCopula(theta,data,corrspec,optimizer,method)
%Calculates the composite likelihood of the Normal copula
%IMPUTS
%theta:      Initial values for the parameters
%data:       A TxN matrix of residuals from some filtration
%cdfdata:    A TxN matrix of the cdf of residuals. It is an optional imput.
%            If you dont provide then the empirical CDF of the residuals is 
%            taken (Canonical maximum likelihood)

% OUTPUTS:
% comp_LL:    The composite likelihood 
% Rt:         3d array of dynamic correlations
% veclRt:     Matrix with columns the dynamic correlations from every pair.
%             Helps in plotting

%Author: Manthos Vogiatzoglou, U.o.M. 2008
%-------------------------------------------------------------------------
%Author: Manthos Vogiatzoglou, U.o.M. 2008
%-------------------------------------------------------------------------
if nargout==1
    Rt=[]; veclRt=[];
end
if nargin==4
    method='CML';
end
if nargin==3
    method='CML'; optimizer='fmincon';
end
if min(min(data))<0 || max(max(data))>1
if strcmp(method,'IFM')==1
    trdata=norminv(normcdf(data));
end
if strcmp(method,'CML')==1
    trdata=norminv(empiricalCDF(data));
end
else
    trdata=norminv(data);
end
[T,N]=size(data);
if strcmp(optimizer,'fmincon')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta,trdata);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta,trdata);
elseif strcmp(corrspec,'Patton')==1 && N==2
    display('Patton is unconstrained by default')
    [Rt, veclRt]=Pattoneq(theta,data);
elseif strcmp(corrspec,'Patton')==1 && N==2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta,trdata);
end
elseif strcmp(optimizer,'fminunc')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta,trdata,optimizer);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta,trdata,optimizer);
elseif strcmp(corrspec,'Patton')==1 && N==2
    [Rt, veclRt]=Pattoneq(theta,data);
elseif strcmp(corrspec,'Patton')==1 && N>2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta,trdata,optimizer);
end  
end
xylik=zeros(T,N*(N-1)/2); % 4 the CL estimation
ssquares=zeros(T,N*(N-1)/2); % 4 the CL estimation
counter=0;
for i=1:N
    for j=(i+1):N
        counter=counter+1;
        x =trdata(:,i);
        y =trdata(:,j);
        xylik(:,counter)=x.*y;
        ssquares(:,counter)=x.^2+y.^2;
    end
end

CL = -1*(2*(1-veclRt.^2)).^(-1).*(ssquares-2*veclRt.*xylik);
CL = CL + 0.5*(ssquares);
CL = CL - 0.5*log(1-veclRt.^2);
likelihoods = sum(CL);
likelihoods= -likelihoods;
comp_LL= mean(likelihoods);
%--------------------------------------------------------------------
